/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.feature.ScatterFeature;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;

public abstract class SkyScatterFeature
extends ScatterFeature {
    public SkyScatterFeature(int radius) {
        super(radius);
    }

    @Override
    protected int getChance() {
        return 10;
    }

    @Override
    public boolean canGenerate(ISeedReader world, Random random, BlockPos center, BlockPos blockPos, float radius) {
        if (!world.func_175623_d(blockPos)) {
            return false;
        }
        for (Direction dir : BlockHelper.HORIZONTAL_DIRECTIONS) {
            if (world.func_175623_d(blockPos.func_177972_a(dir))) continue;
            return false;
        }
        int maxD = this.getYOffset() + 2;
        int maxV = this.getYOffset() - 2;
        return BlockHelper.upRay((IWorldReader)world, blockPos, maxD) > maxV && BlockHelper.downRay((IWorldReader)world, blockPos, maxD) > maxV;
    }

    @Override
    protected boolean canSpawn(ISeedReader world, BlockPos pos) {
        return true;
    }

    @Override
    protected BlockPos getCenterGround(ISeedReader world, BlockPos pos) {
        return new BlockPos(pos.func_177958_n(), ModMathHelper.randRange(32, 192, world.func_201674_k()), pos.func_177952_p());
    }

    @Override
    protected boolean getGroundPlant(ISeedReader world, BlockPos.Mutable pos) {
        pos.func_185336_p(pos.func_177956_o() + ModMathHelper.randRange(-this.getYOffset(), this.getYOffset(), world.func_201674_k()));
        return true;
    }
}

